<?php
//settings
$cache_ext  = '.html'; //file extension
$cache_time     = 28800;  //Cache file expires after these seconds (1 hour = 3600 sec) (8 hour = 28800 sec)
$cache_folder   = 'cache/'; //folder to store Cache files
$ignore_pages   = array('', '');

$dynamic_url    = 'http://'.$_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'] . $_SERVER['QUERY_STRING']; // requested dynamic page (full url)
$cache_file     = $cache_folder.md5($dynamic_url).$cache_ext; // construct a cache file
$ignore = (in_array($dynamic_url,$ignore_pages))?true:false; //check if url is in ignore list

if (!$ignore && file_exists($cache_file) && time() - $cache_time < filemtime($cache_file)) { //check Cache exist and it's not expired.
    ob_start('ob_gzhandler'); //Turn on output buffering, "ob_gzhandler" for the compressed page with gzip.
    readfile($cache_file); //read Cache file
    echo '<!-- cached page - '.date('l jS \of F Y h:i:s A', filemtime($cache_file)).', Page : '.$dynamic_url.' -->';
    ob_end_flush(); //Flush and turn off output buffering
    exit(); //no need to proceed further, exit the flow.
}
//Turn on output buffering with gzip compression.
ob_start('ob_gzhandler');
?>
<?php include('siteconfig.php'); ?>
<!doctype html>
<html>
    <head>
      <meta charset="utf-8">
	  <meta name="viewport" content="width=device-width">
      <title><?php echo $homepage_title; ?></title>
      <meta name="description" content="<?php echo $homepage_desc; ?>" />
      <meta name="keywords" content="<?php echo $site_keywords; ?>" />
	  <meta property="og:site_name" content="<?php echo $site_title; ?>"/>
	  <meta property="og:locale" content="en_US"/>
      <meta property="og:type" content="website"/>
      <meta property="og:title" content="<?php echo $homepage_title; ?>"/>
      <meta property="og:description" content="<?php echo $homepage_desc; ?>"/>
      <link href="<?php echo $site_url;?>/style.css" rel="stylesheet" type="text/css">
      <link href='https://fonts.googleapis.com/css?family=Open+Sans:400,700' rel='stylesheet' type='text/css'>
      <link href="<?php echo $site_url;?>/favicon.ico" rel="shortcut icon" type="image/x-icon">
	  <script type="text/javascript" src="https://ajax.googleapis.com/ajax/libs/jquery/1.9.1/jquery.min.js"></script>
	  <script type="text/javascript" src="<?php echo $site_url;?>/js/jquery.jcarousel.min.js"></script>
	  <?php include 'ads/head_code.php'; ?>
    </head>
<body>
<?php include 'includes/header.php'; ?>
<?php
function cano($s){
	$s = $output = trim(preg_replace(array("`'`", "`[^a-z0-9]+`"),  array("", "-"), strtolower($s)), "-");
	return $s;
}
function add3dots($string, $repl, $limit) 
{
  if(strlen($string) > $limit) 
  {
    return substr($string, 0, $limit) . $repl; 
  }
  else 
  {
    return $string;
  }
}
?> 

<script>
jQuery(document).ready(function($){
if(jQuery().jcarousel) {
	// Featured Carousel - Horizontal 
	$(window).bind('load resize', function(){
		
		$('.fcarousel-6').deCarousel();
		$('.fcarousel-5').deCarousel();
	});
	// games carousel
	$('.jcarousel').jcarousel({
        wrap: 'circular'
    });
	$('.jcarousel').jcarouselAutoscroll({
	target: '+=3',
	interval: 3000,
    autostart: true
	});
		
	// Featured Carousel - Vertical 
	$('.carousel-clip').jcarousel({
		vertical: true,
		wrap: 'circular'
	});
	$('.carousel-prev').jcarouselControl({target: '-=4'});
	$('.carousel-next').jcarouselControl({target: '+=4'});
}
});
</script>
<div class="scrollback">
<div class="wrap">
<div class="scrollcontent">
<div class="carousel fcarousel fcarousel-6">
<div class="scrolltitle">
<h1><?php echo $home_carousel_title; ?></h1>
</div>
<div class="carousel-container">
<div class="jcarousel">
<ul>
<?php
$data = file_get_contents('http://www.giantbomb.com/api/game/'.$fgameid_1.'/?api_key='.$giantbomb_key.'&field_list=id,image,name&format=json');
$vresult = json_decode($data);
echo '<li><div class="homethumb"><a href="'.$site_url.'/game/'.$vresult->results->id.'/'.cano($vresult->results->name).'/"><img src="'.$vresult->results->image->small_url.'" alt="" itemprop="image" width="234px" ><span class="overlay"><i class="icon-gamepad"></i><p>'.$vresult->results->name.'</p></span></a></div></li>';

$data = file_get_contents('http://www.giantbomb.com/api/game/'.$fgameid_2.'/?api_key='.$giantbomb_key.'&field_list=id,image,name&format=json');
$vresult = json_decode($data);
echo '<li><div class="homethumb"><a href="'.$site_url.'/game/'.$vresult->results->id.'/'.cano($vresult->results->name).'/"><img src="'.$vresult->results->image->small_url.'" alt="" itemprop="image" width="234px" ><span class="overlay"><i class="icon-gamepad"></i><p>'.$vresult->results->name.'</p></span></a></div></li>';

$data = file_get_contents('http://www.giantbomb.com/api/game/'.$fgameid_3.'/?api_key='.$giantbomb_key.'&field_list=id,image,name&format=json');
$vresult = json_decode($data);
echo '<li><div class="homethumb"><a href="'.$site_url.'/game/'.$vresult->results->id.'/'.cano($vresult->results->name).'/"><img src="'.$vresult->results->image->small_url.'" alt="" itemprop="image" width="234px" ><span class="overlay"><i class="icon-gamepad"></i><p>'.$vresult->results->name.'</p></span></a></div></li>';

$data = file_get_contents('http://www.giantbomb.com/api/game/'.$fgameid_4.'/?api_key='.$giantbomb_key.'&field_list=id,image,name&format=json');
$vresult = json_decode($data);
echo '<li><div class="homethumb"><a href="'.$site_url.'/game/'.$vresult->results->id.'/'.cano($vresult->results->name).'/"><img src="'.$vresult->results->image->small_url.'" alt="" itemprop="image" width="234px" ><span class="overlay"><i class="icon-gamepad"></i><p>'.$vresult->results->name.'</p></span></a></div></li>';

$data = file_get_contents('http://www.giantbomb.com/api/game/'.$fgameid_5.'/?api_key='.$giantbomb_key.'&field_list=id,image,name&format=json');
$vresult = json_decode($data);
echo '<li><div class="homethumb"><a href="'.$site_url.'/game/'.$vresult->results->id.'/'.cano($vresult->results->name).'/"><img src="'.$vresult->results->image->small_url.'" alt="" itemprop="image" width="234px" ><span class="overlay"><i class="icon-gamepad"></i><p>'.$vresult->results->name.'</p></span></a></div></li>';

$data = file_get_contents('http://www.giantbomb.com/api/game/'.$fgameid_6.'/?api_key='.$giantbomb_key.'&field_list=id,image,name&format=json');
$vresult = json_decode($data);
echo '<li><div class="homethumb"><a href="'.$site_url.'/game/'.$vresult->results->id.'/'.cano($vresult->results->name).'/"><img src="'.$vresult->results->image->small_url.'" alt="" itemprop="image" width="234px" ><span class="overlay"><i class="icon-gamepad"></i><p>'.$vresult->results->name.'</p></span></a></div></li>';

$data = file_get_contents('http://www.giantbomb.com/api/game/'.$fgameid_7.'/?api_key='.$giantbomb_key.'&field_list=id,image,name&format=json');
$vresult = json_decode($data);
echo '<li><div class="homethumb"><a href="'.$site_url.'/game/'.$vresult->results->id.'/'.cano($vresult->results->name).'/"><img src="'.$vresult->results->image->small_url.'" alt="" itemprop="image" width="234px" ><span class="overlay"><i class="icon-gamepad"></i><p>'.$vresult->results->name.'</p></span></a></div></li>';

$data = file_get_contents('http://www.giantbomb.com/api/game/'.$fgameid_8.'/?api_key='.$giantbomb_key.'&field_list=id,image,name&format=json');
$vresult = json_decode($data);
echo '<li><div class="homethumb"><a href="'.$site_url.'/game/'.$vresult->results->id.'/'.cano($vresult->results->name).'/"><img src="'.$vresult->results->image->small_url.'" alt="" itemprop="image" width="234px" ><span class="overlay"><i class="icon-gamepad"></i><p>'.$vresult->results->name.'</p></span></a></div></li>';
?>    
</ul>
</div><!-- end .jcarousel -->
<div class="carousel-prev"></div>
<div class="carousel-next"></div>
</div><!-- end .carousel-container -->
</div><!-- end .carousel -->
</div><!-- end .scrollcontent -->
</div><!-- end .wrap -->
</div><!-- end .scrollback -->
<div class="after-header"></div>
<div class="wraphome">
<div class="searchcontent">
<div class="box-header"><h2><?php echo $home_videos_title; ?></h2></div>
<div class="box-home-videos">
<ul>
<?php
$data = file_get_contents('http://www.giantbomb.com/api/videos/?api_key='.$giantbomb_key.'&sort=publish_date:desc&field_list=id,image,name&limit=9&format=json');
$response = json_decode($data);

if ($response->results==NULL){
echo '';	
}else{	
	
    foreach ($response->results as $vresult)
	
{
	echo '<li><div class="homevideothumb"><a href="'.$site_url.'/video/'.$vresult->id.'/'.cano($vresult->name).'/"><img src="'.$vresult->image->small_url.'" alt="'.$vresult->name.'" width="230px" height="129px" border="0">
	<span class="overlay"><i class="icon-play-circle"></i></span></a></div><span class="videosubtitle"><a href="'.$site_url.'/video/'.$vresult->id.'/'.cano($vresult->name).'/">'.$vresult->name.'</a></span>
	</li>';
		
}
}
?>
</ul>
</div>
<?php 
$homead = file_get_contents("ads/homepage_ad_728x90.php",NULL);
if(isset($homead) and !empty($homead)): ?>
<center>
<div style="float:left;margin:5px 0px 5px 0px;">
<?php echo $homead; ?>
</div>
</center>
<?php endif; ?>
<div class="box-home-reviews">
<div class="box-header"><h2><?php echo $home_reviews_title; ?></h2></div>
<ul>
<?php
$data = file_get_contents('http://www.giantbomb.com/api/reviews/?api_key='.$giantbomb_key.'&sort=publish_date:desc&limit=8&format=json');
$response = json_decode($data);

if ($response->results==NULL){
echo '';	
}else{	
	
    foreach ($response->results as $vresult)
	
{
	echo '<li><div class="homereview"><a href="'.$site_url.'/review/'.substr($vresult->api_detail_url, 42, -1).'/'.cano($vresult->release->name).'/">'.$vresult->release->name.'</a>
	<div class="starbox"><span class="stars">'.$vresult->score.'</span></div>
	<p>'.add3dots($vresult->deck, "...", 135).'</p>
	<div class="details"><i class="icon-calendar"></i> '.substr($vresult->publish_date,0,10).' <span class="barsep"></span><i class="icon-desktop"></i> '.$vresult->platforms.'</div></div></li>';
		
}
}
?>
</ul>
</div>
</div>
<div class="sidebar">
<?php include("includes/sidebar.php"); ?>
</div><!-- end .sidebar -->
</div><!-- end .wrap -->
<?php include 'includes/footer.php'; ?>
<script language="JavaScript" type="text/javascript" src="<?php echo $site_url;?>/js/star-rating.js"></script>
		<script type="text/javascript" language="JavaScript">

      jQuery(function() {
           jQuery('span.stars').stars();
      });

</script>
</body>
</html>
<?php
######## Your Website Content Ends here #########

if (!is_dir($cache_folder)) { //create a new folder if we need to
    mkdir($cache_folder);
}
if(!$ignore){
    $fp = fopen($cache_file, 'w');  //open file for writing
    fwrite($fp, ob_get_contents()); //write contents of the output buffer in Cache file
    fclose($fp); //Close file pointer
}
ob_end_flush(); //Flush and turn off output buffering

?>